#version 330 core
layout (location=0) in vec2 aPos;          // quad [-0.5,0.5]^2

// per-instance attributes
layout (location=1) in vec3 iCenter;
layout (location=2) in vec4 iColorAlpha;
layout (location=3) in vec4 iUV;
layout (location=4) in vec2 iSize;
layout (location=5) in float iRotation;
layout (location=6) in int iBlendMode;

uniform mat4 uView;
uniform mat4 uProj;

out vec2 TexCoord;
out vec4 VertexColor;
flat out int BlendMode;

void main() {
    float w = iSize.x * 0.5;
    float h = iSize.y * 0.5;

    vec3 right = vec3(uView[0][0], uView[1][0], uView[2][0]);
    vec3 up    = vec3(uView[0][1], uView[1][1], uView[2][1]);

    vec2 local = vec2(aPos.x * 2.0 * w, aPos.y * 2.0 * h);

    float rad = radians(iRotation);
    float cosR = cos(rad), sinR = sin(rad);
    float rx = local.x * cosR - local.y * sinR;
    float ry = local.x * sinR + local.y * cosR;

    vec3 pos = iCenter + right * rx + up * ry;
    gl_Position = uProj * uView * vec4(pos, 1.0);

    float u = iUV.x + ((aPos.x > 0.0) ? iUV.z : 0.0);
    float v = iUV.y + ((aPos.y > 0.0) ? 0.0 : iUV.w);
    TexCoord = vec2(u, v);

    VertexColor = iColorAlpha;
    BlendMode = iBlendMode; // vẫn pass ra nếu cần debug
}
