#version 330 core
layout (location=0) in vec2 aPos;
layout (location=1) in vec3 iCenter;
layout (location=2) in vec3 iColor;
layout (location=3) in float iScale;
layout (location=4) in float iAlpha;
layout (location=5) in int   iDigit;
layout (location=6) in float iOffsetX;
layout (location=7) in int   iTexType;
layout (location=8) in float iRotation; // rotation từ CPU

uniform mat4 uView;
uniform mat4 uProj;

out vec2 TexCoord;
out vec3 Color;
out float Alpha;
flat out int Digit;
flat out int TexType;

void main()
{
    // tâm sang view-space
    vec4 centerV = uView * vec4(iCenter, 1.0);

    // local quad offset
    vec2 quadPos = aPos + vec2(iOffsetX / iScale, 0.0);

    // xoay quanh Z
    float cosR = cos(iRotation);
    float sinR = sin(iRotation);
    vec2 rotPos;
    rotPos.x = quadPos.x * cosR - quadPos.y * sinR;
    rotPos.y = quadPos.x * sinR + quadPos.y * cosR;

    vec3 viewPos = centerV.xyz + vec3(rotPos.x * iScale, rotPos.y * iScale, 0.0);
    gl_Position = uProj * vec4(viewPos, 1.0);

    TexCoord = aPos + 0.5; // chuẩn [-0.5..0.5] → [0..1]
    Color = iColor;
    Alpha = iAlpha;
    Digit = iDigit;
    TexType = iTexType;
}
