#version 430 core
layout(location=0) in vec3 aPos;
layout(location=1) in vec3 aNorm;
layout(location=2) in vec2 aTex;
layout(location=3) in uint aBone;

layout(location=4)  in vec4 i_bodyLight;
layout(location=5)  in vec4 i_lightPosition;  // .w dùng như alpha-weight
layout(location=6)  in vec4 i_meshUV;
layout(location=7)  in int  i_enableLight;
layout(location=8)  in int  i_boneBaseIndex;
layout(location=9)  in vec4 i_setting1;
layout(location=10) in vec4 i_setting2;

uniform mat4 uProj, uView;
layout(std430, binding=0) buffer Bones { vec4 b4[]; };

out vec4 v_color0;
out vec2 v_texcoord0;
out vec4 v_setting1;
out vec4 v_setting2;

void skin(inout vec3 P, inout vec3 N) {
    int base = i_boneBaseIndex + int(aBone);
    vec4 r0=b4[base+0], r1=b4[base+1], r2=b4[base+2];
    P = vec3(dot(r0.xyz,aPos)+r0.w,
             dot(r1.xyz,aPos)+r1.w,
             dot(r2.xyz,aPos)+r2.w);
    N = normalize(vec3(dot(r0.xyz,aNorm),
                       dot(r1.xyz,aNorm),
                       dot(r2.xyz,aNorm)));
}

vec4 doLighting(vec3 n) {
    if(i_enableLight==0) return i_bodyLight;
    float lit = ((dot(n, i_lightPosition.xyz)*0.8)+0.4)*i_lightPosition.w + (1.0 - i_lightPosition.w);
    lit = max(lit, 0.2);
    return clamp(i_bodyLight * vec4(lit,lit,lit, i_lightPosition.w), 0.0, 1.0);
}

void main(){
    vec3 P,N; skin(P,N);
    gl_Position = uProj * uView * vec4(P,1.0);
    v_color0 = doLighting(N);
    v_texcoord0 = aTex + i_meshUV.xy;   // đúng gốc
    v_setting1 = i_setting1;
    v_setting2 = i_setting2;
}
