#version 330 core

layout(location = 0) in vec2 aPos;         
layout(location = 1) in vec3 instCenter;   
layout(location = 2) in vec4 instColor;     
layout(location = 3) in vec4 instUV;        
layout(location = 4) in vec2 instSize;     
layout(location = 5) in float instRotation; 
layout(location = 6) in int instBlend;

uniform mat4 uProj;
uniform mat4 uView;

out vec2 vUV;
out vec4 vColor;
flat out int vBlendMode;

void main()
{
    vec2 uvBase = instUV.xy;
    vec2 uvSize = instUV.zw;

    vec2 uvLUT[4] = vec2[](
        vec2(0.0, 1.0), // 0 -> BL -> (u,     v+vh)
        vec2(1.0, 1.0), // 1 -> BR -> (u+uw,  v+vh)
        vec2(0.0, 0.0), // 2 -> TL -> (u,     v)
        vec2(1.0, 0.0)  // 3 -> TR -> (u+uw,  v)
    );
    vUV = uvBase + uvLUT[gl_VertexID] * uvSize;
    vec4 centerV = uView * vec4(instCenter, 1.0);
    vec2 local = aPos * instSize;
    float c = cos(instRotation);
    float s = sin(instRotation);
    mat2 R = mat2(c, -s, s, c);
    vec2 rotated = R * local;
    vec4 posV = vec4(centerV.xy + rotated, centerV.z, centerV.w);
    gl_Position = uProj * posV;
    vColor = instColor;
    vBlendMode = instBlend;
}
